<?php
//header('Content-Type: text/html; charset=UTF-8');
ini_set('Display_erros','0');

//  session_start();

class Bdd{
    private $conexion;
    public $sql;
    private $numeroRegistro = 0;
    private $dataRespSql = array();
    private $codificacion ='utf8';

    public function __construct($sql = "", $baseDir = '') {
        $this->sql = $sql;
        $this->conexion($baseDir);
        if (trim($sql) != "") {
            $this->ejecuta_SQL();
        }
    }

    public function getConexion() {
        return $this->conexion;
    }

    private function conexion($baseDir)
    {  // echo 'BDDSERVIDOR = '.BDDSERVIDOR;
        require_once($baseDir."conf/config.php");
        $servidor   = BDDSERVIDOR;
        $usuario    = BDDUSUARIO;
        $clave_usu  = BDDCONTRASENA;
        $puerto     = BDDPUERTO;
        $nombre_dbb = BDDNOMBRE;

        try {
            $this->conexion = mysqli_connect($servidor, $usuario, $clave_usu, $nombre_dbb, $puerto);
            mysqli_set_charset($this->conexion, $this->codificacion);
            if (!$this->conexion) {
                throw new Exception("Error al conectar a la base de datos: " . mysqli_connect_error());
            }
            //else{
            //    die($servidor.$usuario.$clave_usu.$puerto.$nombre_dbb);
            //}
            
        } catch (Exception $e) {
            die("<h1>ERROR: ".$e->getMessage()."</h1>");
        }
    }

    public function close()
    {
        mysqli_close($this->conexion);
    }

    /**
     * Ejecuta una consulta preparada y retorna el resultado.
     *
     * @param string $sql La consulta SQL con placeholders.
     * @param string $types Los tipos de los parámetros (e.g., "ss" para dos strings).
     * @param array $params Los valores de los parámetros en el mismo orden que los placeholders.
     * @return array|bool Retorna el array de resultados o false en caso de error.
     */
    public function ejecutarConsultaPreparada($sql, $types = "", $params = []) {
        // Preparar la consulta
        $stmt = mysqli_prepare($this->conexion, $sql);
        if ($stmt === false) {
            error_log("Error al preparar la consulta: " . mysqli_error($this->conexion));
            return false;
        }

        // Si hay parámetros, bindearlos
        if (!empty($params)) {
            // Asegurarnos de que $params es un array indexado numéricamente
            $params = array_values($params);
            mysqli_stmt_bind_param($stmt, $types, ...$params);
        }

        // Ejecutar la consulta
        if (!mysqli_stmt_execute($stmt)) {
            error_log("Error al ejecutar la consulta: " . mysqli_stmt_error($stmt));
            mysqli_stmt_close($stmt);
            return false;
        }

        // Obtener el resultado
        $result = mysqli_stmt_get_result($stmt);

        // Procesar resultados (similar a ejecuta_SQL)
        $this->dataRespSql = [];
        $this->numeroRegistro = 0;

        if ($result instanceof mysqli_result) {
            $i = 0;
            while ($row = mysqli_fetch_assoc($result)) {
                $this->dataRespSql[$i] = $row;
                $i++;
            }
            $this->numeroRegistro = $i;
        } else {
            // Para INSERT, UPDATE, DELETE
            $this->numeroRegistro = mysqli_stmt_affected_rows($stmt);
        }

        // Cerrar el statement
        mysqli_stmt_close($stmt);

        return $this->dataRespSql;
    }

    /**
     * Versión estática para usar sin instanciar la clase
     */
    public static function ejecutarConsulta($conexion, $sql, $types = "", $params = []) {
        // Preparar la consulta
        $stmt = mysqli_prepare($conexion, $sql);
        if ($stmt === false) {
            error_log("Error al preparar la consulta: " . mysqli_error($conexion));
            return false;
        }

        // Si hay parámetros, bindearlos
        if (!empty($params)) {
            $params = array_values($params);
            mysqli_stmt_bind_param($stmt, $types, ...$params);
        }

        // Ejecutar la consulta
        if (!mysqli_stmt_execute($stmt)) {
            error_log("Error al ejecutar la consulta: " . mysqli_stmt_error($stmt));
            mysqli_stmt_close($stmt);
            return false;
        }

        // Obtener el resultado
        $result = mysqli_stmt_get_result($stmt);
        
        // Cerrar el statement
        mysqli_stmt_close($stmt);

        return $result;
    }

    public function dataSql() {
        return $this->dataRespSql;
    }

    public function numeroRegistroSqlAfectado(){
        return $this->numeroRegistro;
    }

    private function ejecuta_SQL()
    {

        if (mysqli_connect_errno()){
            return 34404; /*error de conexion a la base de datos*/
        }
        else {//echo("<br>".$this->sql);//echo(mysqli_error($this->conexion));

            
            if(substr_count($this->sql, ';') > 1){
                $result=mysqli_multi_query($this->conexion,$this->sql);
                //echo ('SLQ: ');
                //die('ejecuta_SQL_multiple: <br>'.$this->sql);

            }else{
                $result=mysqli_query($this->conexion,$this->sql);
                //$result=mysqli_multi_query($this->conexion,$this->sql);
                $this->numeroRegistro = mysqli_affected_rows($this->conexion);
                if($this->numeroRegistro == -1){
                    $result=mysqli_multi_query($this->conexion,$this->sql);
                    $this->numeroRegistro = mysqli_affected_rows($this->conexion);
                }
            }

            if (is_bool($result) === false) { //no es booleano?
                $i = 0;
                while($row = mysqli_fetch_assoc($result)) {
                    $this->dataRespSql[$i] = $row;
                    $i++;
                }
            }
        }
    }

    public function sqlError(){
        return mysqli_error($this->conexion);
    }

    public function multipleQueries($sql) {
        // Expresión regular para detectar múltiples consultas
        $pattern = '/(?:;[^\n\r]*\n?)+/';
    
        // Buscamos múltiples consultas en la cadena
        if (preg_match($pattern, $sql)) {
            return true; // La consulta tiene múltiples consultas
        } else {
            return false; // La consulta no tiene múltiples consultas
        }
    }

    /**
     * Ejecuta una consulta preparada y retorna el resultado.
     *
     * @param string $sql La consulta SQL con placeholders.
     * @param string $types Los tipos de los parámetros (e.g., "ss" para dos strings).
     * @param array $params Los valores de los parámetros en el mismo orden que los placeholders.
     * @return array|bool Retorna el array de resultados o false en caso de error.
     */
    public function test__ejecutarConsultaPreparada($sql, $types = "", $params = []) {
        // Asignar la consulta original a $this->sql
        $this->sql = $sql;
        
        // Construir el SQL con valores reales para depuración
        $sqlDebug = $sql;
        if (!empty($params)) {
            $params = array_values($params);
            $paramIndex = 0;
            
            // Reemplazar cada ? por el valor correspondiente
            $sqlDebug = preg_replace_callback('/\?/', function($matches) use (&$paramIndex, $params, $types) {
                if ($paramIndex >= count($params)) {
                    return '?';
                }
                
                $value = $params[$paramIndex];
                $type = $paramIndex < strlen($types) ? $types[$paramIndex] : 's';
                
                // Formatear según el tipo
                switch ($type) {
                    case 's': // string
                        $value = "'" . addslashes($value) . "'";
                        break;
                    case 'i': // integer
                        $value = (int)$value;
                        break;
                    case 'd': // double/float
                        $value = (float)$value;
                        break;
                    case 'b': // blob
                        $value = "'" . addslashes($value) . "'";
                        break;
                    default:
                        $value = "'" . addslashes($value) . "'";
                }
                
                $paramIndex++;
                return $value;
            }, $sqlDebug);
            
            // Asignar el SQL con valores reales a $this->sql
            $this->sql = $sqlDebug;
        }

        // Preparar la consulta
        $stmt = mysqli_prepare($this->conexion, $sql);
        if ($stmt === false) {
            error_log("Error al preparar la consulta: " . mysqli_error($this->conexion));
            return false;
        }

        // Si hay parámetros, bindearlos
        if (!empty($params)) {
            // Asegurarnos de que $params es un array indexado numéricamente
            $params = array_values($params);
            mysqli_stmt_bind_param($stmt, $types, ...$params);
        }

        // Ejecutar la consulta
        if (!mysqli_stmt_execute($stmt)) {
            error_log("Error al ejecutar la consulta: " . mysqli_stmt_error($stmt));
            mysqli_stmt_close($stmt);
            return false;
        }

        // Obtener el resultado
        $result = mysqli_stmt_get_result($stmt);

        // Procesar resultados (similar a ejecuta_SQL)
        $this->dataRespSql = [];
        $this->numeroRegistro = 0;

        if ($result instanceof mysqli_result) {
            $i = 0;
            while ($row = mysqli_fetch_assoc($result)) {
                $this->dataRespSql[$i] = $row;
                $i++;
            }
            $this->numeroRegistro = $i;
        } else {
            // Para INSERT, UPDATE, DELETE
            $this->numeroRegistro = mysqli_stmt_affected_rows($stmt);
        }

        // Cerrar el statement
        mysqli_stmt_close($stmt);

        return $this->sql;
    }

    public function permisoCasoUso($casoUso,$usuario){ /*Pendiente */
       /* $sql = "SELECT * FROM seg_usuarios WHERE login = ? AND clave = ? AND status_user = 1";
        $types = "i";
        $params = [$casoUso];*/

        $sql = "SELECT Z.caso_uso,(SELECT cod_caso_uso FROM seg_perfiles_usuario 
                          WHERE Z.cod_caso_uso = cod_caso_uso AND login = ?
                       )as 'perfil_usuario',
                       (SELECT A.cod_caso_uso 
                        FROM seg_perfiles_roles as A, seg_usuarios_roles as C
                        WHERE C.login = ?
                          AND Z.cod_caso_uso = A.cod_caso_uso
                          AND C.cod_rol = A.cod_rol
                    )as 'perfil_rol' 
                FROM seg_caso_uso as Z 
                WHERE Z.cod_caso_uso = ?";
        
        $types = "ssi";
        $params = [$usuario,$usuario,$casoUso];

        $dta= $this->ejecutarConsultaPreparada($sql, $types, $params);
/*echo $usuario;
print_r($dta); 
die();
// */
        if(!is_null($dta[0]['perfil_usuario'])){
            return true;
        }else if(!is_null($dta[0]['perfil_rol'])){
            return true;
        }else{ 
            echo "<script>alert('No tiene permiso para ".$dta[0]['caso_uso'].", consulte a su administrador de sistemas') </script>";            
			/*echo "<script>window.location='login.php' </script>";*/
            return false;
        }
    }
/*
    private function select_SQL()
    {
        if (mysqli_connect_errno()){
            return 34404; //error de conexion a la base de datos
        }
        else {//echo($this->sql);
            $result=mysqli_query($this->conexion,$this->sql);
    
            if (is_bool($result) === false) { //no es booleano?
                $i = 0;
                while($row = mysqli_fetch_assoc($result)) {

                  //  print_r($row); die();
                    for($j=0;$j<count($row);$j++){
                        $this->dataRespSql[$i][$j] = $row[$j];
                    }

                    $i++;
                }
            }
        }
    }*/

}// fin class Bdd

?>
