<?php
session_start();
// Destruir todas las variables de sesión
$_SESSION = array();
// Finalmente, destruir la sesión
session_destroy();
?>
<script>
    window.onload= function(){
        document.getElementById('txtPassword').value = '';
    }
function encryptPassword() {

    var passwordField = document.getElementById('txtPassword');
    var hashedPassword = sha256(passwordField.value);
    passwordField.value = hashedPassword;
    
    return true;
}

function sha256(texto) {
    // Constantes SHA-256
    const K = new Uint32Array([
        0x428a2f98, 0x71374491, 0xb5c0fbcf, 0xe9b5dba5, 0x3956c25b, 0x59f111f1, 0x923f82a4, 0xab1c5ed5,
        0xd807aa98, 0x12835b01, 0x243185be, 0x550c7dc3, 0x72be5d74, 0x80deb1fe, 0x9bdc06a7, 0xc19bf174,
        0xe49b69c1, 0xefbe4786, 0x0fc19dc6, 0x240ca1cc, 0x2de92c6f, 0x4a7484aa, 0x5cb0a9dc, 0x76f988da,
        0x983e5152, 0xa831c66d, 0xb00327c8, 0xbf597fc7, 0xc6e00bf3, 0xd5a79147, 0x06ca6351, 0x14292967,
        0x27b70a85, 0x2e1b2138, 0x4d2c6dfc, 0x53380d13, 0x650a7354, 0x766a0abb, 0x81c2c92e, 0x92722c85,
        0xa2bfe8a1, 0xa81a664b, 0xc24b8b70, 0xc76c51a3, 0xd192e819, 0xd6990624, 0xf40e3585, 0x106aa070,
        0x19a4c116, 0x1e376c08, 0x2748774c, 0x34b0bcb5, 0x391c0cb3, 0x4ed8aa4a, 0x5b9cca4f, 0x682e6ff3,
        0x748f82ee, 0x78a5636f, 0x84c87814, 0x8cc70208, 0x90befffa, 0xa4506ceb, 0xbef9a3f7, 0xc67178f2
    ]);

    // Valores hash iniciales
    let h0 = 0x6a09e667, h1 = 0xbb67ae85, h2 = 0x3c6ef372, h3 = 0xa54ff53a;
    let h4 = 0x510e527f, h5 = 0x9b05688c, h6 = 0x1f83d9ab, h7 = 0x5be0cd19;

    // Función de rotación derecha
    const rotr = (n, x) => (x >>> n) | (x << (32 - n));

    // Preparar el mensaje con padding
    const msg = new TextEncoder().encode(texto);
    const len = msg.length;
    const totalLen = ((len + 8 + 64) & -64) || 64;
    const padded = new Uint8Array(totalLen);
    
    // Copiar el mensaje original
    padded.set(msg);
    
    // Añadir bit '1'
    padded[len] = 0x80;
    
    // Añadir longitud del mensaje en bits (big-endian) en los últimos 64 bits
    const bitLen = len * 8;
    const view = new DataView(padded.buffer);
    view.setUint32(totalLen - 8, (bitLen / 0x100000000) >>> 0, false);
    view.setUint32(totalLen - 4, bitLen >>> 0, false);

    // Procesar cada bloque de 512 bits (64 bytes)
    for (let offset = 0; offset < totalLen; offset += 64) {
        const block = new Uint32Array(64);
        
        // Convertir bloque a palabras de 32 bits (big-endian)
        for (let i = 0; i < 16; i++) {
            block[i] = view.getUint32(offset + i * 4, false);
        }

        // Extender a 64 palabras
        for (let i = 16; i < 64; i++) {
            const s0 = rotr(7, block[i-15]) ^ rotr(18, block[i-15]) ^ (block[i-15] >>> 3);
            const s1 = rotr(17, block[i-2]) ^ rotr(19, block[i-2]) ^ (block[i-2] >>> 10);
            block[i] = (block[i-16] + s0 + block[i-7] + s1) >>> 0;
        }

        // Inicializar variables de trabajo
        let [a, b, c, d, e, f, g, h] = [h0, h1, h2, h3, h4, h5, h6, h7];

        // Ronda de compresión principal
        for (let i = 0; i < 64; i++) {
            const S1 = rotr(6, e) ^ rotr(11, e) ^ rotr(25, e);
            const ch = (e & f) ^ (~e & g);
            const temp1 = (h + S1 + ch + K[i] + block[i]) >>> 0;
            const S0 = rotr(2, a) ^ rotr(13, a) ^ rotr(22, a);
            const maj = (a & b) ^ (a & c) ^ (b & c);
            const temp2 = (S0 + maj) >>> 0;

            h = g;
            g = f;
            f = e;
            e = (d + temp1) >>> 0;
            d = c;
            c = b;
            b = a;
            a = (temp1 + temp2) >>> 0;
        }

        // Actualizar valores hash
        h0 = (h0 + a) >>> 0;
        h1 = (h1 + b) >>> 0;
        h2 = (h2 + c) >>> 0;
        h3 = (h3 + d) >>> 0;
        h4 = (h4 + e) >>> 0;
        h5 = (h5 + f) >>> 0;
        h6 = (h6 + g) >>> 0;
        h7 = (h7 + h) >>> 0;
    }

    // Producir el hash final
    const hash = new Uint32Array([h0, h1, h2, h3, h4, h5, h6, h7]);
    const result = new Uint8Array(32);
    const resultView = new DataView(result.buffer);
    
    for (let i = 0; i < 8; i++) {
        resultView.setUint32(i * 4, hash[i], false);
    }

    // Convertir a hexadecimal
    return Array.from(result).map(b => b.toString(16).padStart(2, '0')).join('');
}
    // ✅ **Versión optimizada para navegadores antiguos (sin TextEncoder):**
function sha256Compat(texto) {
    // Convertir string a bytes (compatible con navegadores antiguos)
    function stringToBytes(str) {
        const bytes = [];
        for (let i = 0; i < str.length; i++) {
            const code = str.charCodeAt(i);
            if (code < 0x80) {
                bytes.push(code);
            } else if (code < 0x800) {
                bytes.push(0xC0 | (code >> 6), 0x80 | (code & 0x3F));
            } else if (code < 0x10000) {
                bytes.push(0xE0 | (code >> 12), 0x80 | ((code >> 6) & 0x3F), 0x80 | (code & 0x3F));
            } else {
                bytes.push(0xF0 | (code >> 18), 0x80 | ((code >> 12) & 0x3F), 
                        0x80 | ((code >> 6) & 0x3F), 0x80 | (code & 0x3F));
            }
        }
        return bytes;
    }

    // Constantes SHA-256 (igual que arriba)
    const K = [
        0x428a2f98, 0x71374491, 0xb5c0fbcf, 0xe9b5dba5, 0x3956c25b, 0x59f111f1, 0x923f82a4, 0xab1c5ed5,
        0xd807aa98, 0x12835b01, 0x243185be, 0x550c7dc3, 0x72be5d74, 0x80deb1fe, 0x9bdc06a7, 0xc19bf174,
        0xe49b69c1, 0xefbe4786, 0x0fc19dc6, 0x240ca1cc, 0x2de92c6f, 0x4a7484aa, 0x5cb0a9dc, 0x76f988da,
        0x983e5152, 0xa831c66d, 0xb00327c8, 0xbf597fc7, 0xc6e00bf3, 0xd5a79147, 0x06ca6351, 0x14292967,
        0x27b70a85, 0x2e1b2138, 0x4d2c6dfc, 0x53380d13, 0x650a7354, 0x766a0abb, 0x81c2c92e, 0x92722c85,
        0xa2bfe8a1, 0xa81a664b, 0xc24b8b70, 0xc76c51a3, 0xd192e819, 0xd6990624, 0xf40e3585, 0x106aa070,
        0x19a4c116, 0x1e376c08, 0x2748774c, 0x34b0bcb5, 0x391c0cb3, 0x4ed8aa4a, 0x5b9cca4f, 0x682e6ff3,
        0x748f82ee, 0x78a5636f, 0x84c87814, 0x8cc70208, 0x90befffa, 0xa4506ceb, 0xbef9a3f7, 0xc67178f2
    ];

    let h0 = 0x6a09e667, h1 = 0xbb67ae85, h2 = 0x3c6ef372, h3 = 0xa54ff53a;
    let h4 = 0x510e527f, h5 = 0x9b05688c, h6 = 0x1f83d9ab, h7 = 0x5be0cd19;

    const rotr = (n, x) => (x >>> n) | (x << (32 - n));

    const msg = stringToBytes(texto);
    const len = msg.length;
    const totalLen = ((len + 8 + 64) & -64) || 64;
    const padded = new Array(totalLen).fill(0);
    
    for (let i = 0; i < len; i++) padded[i] = msg[i];
    padded[len] = 0x80;
    
    const bitLen = len * 8;
    padded[totalLen - 8] = (bitLen >>> 24) & 0xFF;
    padded[totalLen - 7] = (bitLen >>> 16) & 0xFF;
    padded[totalLen - 6] = (bitLen >>> 8) & 0xFF;
    padded[totalLen - 5] = bitLen & 0xFF;

    for (let offset = 0; offset < totalLen; offset += 64) {
        const block = new Array(64).fill(0);
        
        for (let i = 0; i < 16; i++) {
            block[i] = (padded[offset + i * 4] << 24) | 
                    (padded[offset + i * 4 + 1] << 16) | 
                    (padded[offset + i * 4 + 2] << 8) | 
                    padded[offset + i * 4 + 3];
        }

        for (let i = 16; i < 64; i++) {
            const s0 = rotr(7, block[i-15]) ^ rotr(18, block[i-15]) ^ (block[i-15] >>> 3);
            const s1 = rotr(17, block[i-2]) ^ rotr(19, block[i-2]) ^ (block[i-2] >>> 10);
            block[i] = (block[i-16] + s0 + block[i-7] + s1) >>> 0;
        }

        let [a, b, c, d, e, f, g, h] = [h0, h1, h2, h3, h4, h5, h6, h7];

        for (let i = 0; i < 64; i++) {
            const S1 = rotr(6, e) ^ rotr(11, e) ^ rotr(25, e);
            const ch = (e & f) ^ (~e & g);
            const temp1 = (h + S1 + ch + K[i] + block[i]) >>> 0;
            const S0 = rotr(2, a) ^ rotr(13, a) ^ rotr(22, a);
            const maj = (a & b) ^ (a & c) ^ (b & c);
            const temp2 = (S0 + maj) >>> 0;

            h = g; g = f; f = e; e = (d + temp1) >>> 0;
            d = c; c = b; b = a; a = (temp1 + temp2) >>> 0;
        }

        h0 = (h0 + a) >>> 0; h1 = (h1 + b) >>> 0; h2 = (h2 + c) >>> 0; h3 = (h3 + d) >>> 0;
        h4 = (h4 + e) >>> 0; h5 = (h5 + f) >>> 0; h6 = (h6 + g) >>> 0; h7 = (h7 + h) >>> 0;
    }

    // Convertir a hexadecimal
    const hash = [h0, h1, h2, h3, h4, h5, h6, h7];
    let result = '';
    
    for (let i = 0; i < hash.length; i++) {
        for (let j = 7; j >= 0; j--) {
            result += ((hash[i] >>> (j * 4)) & 0xF).toString(16);
        }
    }
    
    return result;
}

</script>

<link rel="stylesheet" href="css/login.css">

<div class="custom-login-container" style= "width: 274px">
    <h2 class="custom-login-title">- Please Login -</h2>
    
    <div class="custom-panel">
        <div class="custom-panel-body">
            <div style= "width: 240px; margin: auto"><img src="img/logo.png" alt="" style="width: 240px"></div>
            <form id="formAutencicacion" action="control_login.php" method="POST" onsubmit="return encryptPassword()" style="position: relative; top: 14px;">
                <div class="custom-input-group custom-login-userinput">
                    <!--<span class="custom-input-group-addon"><i class="fas fa-user"></i></span>-->
                    <input id="txtUser" type="text" class="custom-form-control" name="login_usuario" placeholder="Usuario">
                </div>
                <div class="custom-input-group">
                    <!--<span class="custom-input-group-addon"><i class="fas fa-lock"></i></span> -->
                    <input id="txtPassword" type="password" class="custom-form-control" name="password_usuario" placeholder="Clave">
                    <!--<span id="showPassword" class="custom-input-group-btn">
                        <button class="custom-btn custom-reveal" type="button"><i class="fas fa-eye"></i></button>
                    </span>  -->
                </div> 
                <button class="custom-btn custom-btn-primary custom-btn-block custom-login-button" type="submit" style="position: relative; top: 14px;"> <i class="fas fa-sign-in-alt"></i>Enviar</button>
                <div class="custom-checkbox-options custom-login-options">
                    <!-- <label><input type="checkbox"/> Recuerdame</label>
                    <a href="#" class="custom-login-forgot">¿Olvidó Su usuario o contraseña?</a> -->
                </div>        
            </form>            
        </div>
    </div>
</div>
