<?php
use setasign\Fpdi\Fpdi;
use setasign\Fpdi\PdfReader;

//header('Content-Type: application/pdf; charset=utf-8');
require("../lib/fpdf/fpdf.php");
require("../lib/fpdi2/src/autoload.php");
require("../clases/Bdd.php");
require("../clases/Certificado.php");

class PDF extends FPDI
{
    // Cabecera de página
    function Header()
    {
        if($this->header ==1){
            // Logo
            $this->Image('../img/logo.png',162,8,46);
            // Arial bold 15
            $this->SetFont('Arial','B',15);
            // Movernos a la derecha
            $this->Cell(80);
            // Título
            if($_GET["ep"]==0){
                $titulo='Proyectos Realizados y en Ejecución';}
            else{
                $titulo='Proyectos Realizados';
            }
    
            $this->Cell(30,10,utf8_decode($titulo),0,0,'C');
            $this->SetFont('Arial','',8);
            
            // Salto de línea
            $this->Ln(11);
            $this->MultiCell(0,0.2,'',0,0,'J',1);
            $this->Ln(5);
        }
    }

    // Pie de página
    function Footer()
    {
        // Posición: a 1,5 cm del final
        if($this->footer==1){
        $this->SetY(267);
        // // $this->Image('img/pie.png',0.3,240,215);

        //$this->SetY(-1.5);
        // Arial italic 8
        
        // Número de página
        $this->SetFont('Arial','',8);
        $this->MultiCell(0,0.2,'',0,0,'J',1);
        $this->SetFont('Arial','B',8);
        $this->Cell(1,6,'CSF',0,0,'L');
        $this->SetFont('Arial','',8);
        $this->SetX(17);
        $this->Cell(1,6,'Propietario y Confidencial',0,0,'L');
        $this->Cell(0,6,date('M,Y'),0,0,'R');
        // $this->Ln(3);
        // $this->Cell(199.5,8,'Page '.$this->PageNo().'/'.rtrim('{nb}'),0,1,'R');
        //incluir fecha de la generacion del reporte
    }}
}
//die(print_r($_GET));
// Creación del objeto de la clase heredada

$objCertif = new Certificado();
$bdd = new Bdd($objCertif->sql_proyectosRealizado($_GET),'../');
//echo $objCertif->sql_proyectosRealizado($_GET);   // sql para listar los certificados con servicios
$data=$bdd->numeroRegistroSqlAfectado();
if ($data == -1) {
    $data = "<br>".$bdd->sqlError();
}else{
    $data = $bdd->dataSql();
    $data = filtrarFecha($data,$_GET['dd'],$_GET['ha']);
    //$data = $objCertif->imprimirListadoCertif($data);
}

$pdf = new PDF('P','mm','Letter');
$pdf->header=1;
$pdf->footer=1;
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Arial','',10);

$archivoVertificaciones = array();

if (count($data) == 0) { 
    $mn = "No hay nada que reportar...";
            echo "<script language='JavaScript'>";
            echo "  alert('".$mn."');";
            echo "  window.close(); ";  
            echo "</script>";
    return;        
}

for($i=0;$i<count($data);$i++){ 
    
   $pdf->SetFont('Arial','B',10);

    if(strcmp(trim($data[$i]['archivo']),'0') == 0){
        $status = "En Ejecución: ";
    }else{
        $status = "Culminado: ";
    } 

    // $pdf->Write(5,$status); 
    $pdf->SetFont('Arial','',10);
    
    $reemplazar=array('Á','É','Í','Ó','Ú');
    $buscar=array('á','é','í','ó','ú');

    for ($j=0; $j <5 ; $j++) { 
        $nombreCliente=str_replace($buscar[$j],$reemplazar[$j],$data[$i]['NOMBRE_CLIENTE']);
    }

    //$nombreCliente=strtoupper($nombreCliente);
    if($_GET["ep"]==1 && $status=="En Ejecución: "){
        }
    else{
        if(strcmp(trim($data[$i]['FECHA']),'')!=0){
            $fechaCertifi = date_format(date_create($data[$i]['FECHA']),"Y");
        }else{
            $fechaCertifi = '';
        }

        $estudios='';
        if ($_GET['check'] == 1) {
           $estudios='Servicios: '.utf8_decode($data[$i]['NOMBRE_SERVICIO']).'.';
        }

        $pdf->SetFont('Arial','B',10);
        $pdf->MultiCell(0,5,utf8_decode($status),0,0,'J');
        $pdf->SetFont('Arial','',10);
        $pdf->SetX(35);
        
        $data[$i]['NOMBRE_PROYECTO'] = str_replace('“','"',$data[$i]['NOMBRE_PROYECTO']);
        $data[$i]['NOMBRE_PROYECTO'] = str_replace('”','"',$data[$i]['NOMBRE_PROYECTO']);
        $data[$i]['NOMBRE_PROYECTO'] = str_replace('–','-',$data[$i]['NOMBRE_PROYECTO']);
        
        $pdf->MultiCell(0,5,utf8_decode($data[$i]['NOMBRE_PROYECTO']).'. '.utf8_decode($nombreCliente).' '
                            .utf8_decode($data[$i]['LUGAR_EJEC']).' - '.utf8_decode($fechaCertifi).'. '
                            .$estudios, 0, 0,'J');
                            
        $pdf->Ln(10);
        if($status!="En Ejecución: "){
            $nombreArchi= explode('/',trim($data[$i]['archivo']));
            $nombreArchi=$nombreArchi[count($nombreArchi)-1];

            $archivoVertificaciones[$i] = '../archivos/pdf14/'.$nombreArchi;
        }
    }
}

function filtrarFecha($data,$dd,$ha){
    if($dd=='' && $ha=='') $temp=0;
    if($dd!='' && $ha=='') $temp=1;
    if($dd=='' && $ha!='') $temp=2;
    if($dd!='' && $ha!='') $temp=3;
    $j=0;
    //print_r($dd.' '.$ha.' '.$temp);
    switch ($temp){
        case 0:
            $subdata=$data;
            break;
        case 1:
            for ($i=0;$i<count($data);$i++){ 
                if($data[$i]['FECHA'] >= trim($dd)){
                    $subdata[$j] = $data[$i]; 
                    $j++;
                }
            }
            break;
        case 2:
            for ($i=0;$i<count($data);$i++){ 
                if($data[$i]['FECHA'] <= trim($ha)){
                    $subdata[$j] = $data[$i]; 
                    $j++;
                }
            }
            break;
        case 3:
            for ($i=0;$i<count($data);$i++){ 
                if($data[$i]['FECHA'] >= trim($dd) && $data[$i]['FECHA'] <= trim($ha) ){
                    $subdata[$j] = $data[$i]; 
                    $j++;
                }
            }
            break;
    } 
    //print_r($subdata);
    return $subdata;
}

//---------------------------------saca una copia a toda la carpeta con el formato viejo a gs1.4 --------------------------------------
//--------------------------------despues se copiaran solamente los involucardos en el reporte-----------------------------------------
/* if ($handle = opendir("../archivos")) {
     while (false !== ($file = readdir($handle))) {
         if ('.' === $file) continue;
         if ('..' === $file) continue;
    
         $result = shell_exec('gs -sDEVICE=pdfwrite -dCompatibilityLevel=1.4 -dNOPAUSE -dBATCH -sOutputFile="../archivos/pdf14/'.$file.'" "../archivos/'.$file.'" 2>&1');
        // echo $result."<br>";
     }
     closedir($handle);
 }
// */
//---------------------------------concatenamos las copias al pdf que estamos creando --------------------------------------------------
$Salida='I';
if($_GET["is"] == 1){ //validamos si la opcion incluir soporte esta activa
    $files = $archivoVertificaciones;
    $Salida='D';
    foreach ($files as $file) {
         //if (!file_exists($file)) {
         //   echo "<br>El archivo $file no existe.";
         //   continue;
         //}
        $pageCount = $pdf->setSourceFile($file);
        $pdf->header=0;
        for ($i = 0; $i < $pageCount; $i++) {
            $tpl = $pdf->importPage($i + 1, '/MediaBox');
            
            $pdf->addPage('P','Letter',0);
            $pdf->useTemplate($tpl);
        }
    }
}

// ----------------------------- eliminando los archivos copias----------------------------------------
/*$files = glob('../pdf14/archivos/*'); 
foreach($files as $file) {
   
    if(is_file($file)){
        //unlink($file);
    }
}
*/
$pdf->Output($Salida,'listado_certificado.pdf');

?>