<?php
require('../lib/fpdf/fpdf.php');
require("../clases/Bdd.php");
require('../clases/Certificado.php');

class PDF extends FPDF
{
    // Cabecera de página
    function Header()
    {
        // Logo
        $this->Image('../img/logo.png',162,8,46);
        // Arial bold 15
        $this->SetFont('Arial','B',15);
        // Movernos a la derecha
        $this->Cell(80);
        // Título
        $this->Cell(30,10,utf8_decode('Proyectos Realizados y en Ejecución'),0,0,'C');
        // Salto de línea
        $this->Ln(20);
    }

    // Pie de página
    function Footer()
    {
        
        // Posición: a 1,5 cm del final
        $this->SetY(260);
        // // $this->Image('img/pie.png',0.3,240,215);

        //$this->SetY(-1.5);
        // Arial italic 8
        
        // Número de página
        $this->SetFont('Arial','B',12);
        $this->Cell(1,10,'CSF Confidencial',0,0,'L');
        $this->SetFont('Arial','I',8);
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'R');
    }
}

// Creación del objeto de la clase heredada
$objCertif = new Certificado();
$bdd = new Bdd($objCertif->sql_proyectosRealizado(),'../');

    $data=$bdd->numeroRegistroSqlAfectado();
    if ($data == -1) {
        $data = "<br>".$bdd->sqlError();
    }else{
        $data = $bdd->dataSql();
        //$data = $objCertif->imprimirListadoCertif($data);
    }

$pdf = new PDF('P','mm','Letter');
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Arial','',10);



// for($i=0;$i<count($data);$i++){

//  //   $contenidoFila = '<b>'.$data[$i]['AVANCE'].'<b>'.$data[$i]['NOMBRE_PROYECTO'].' '.$data[$i]['NOMBRE_SERVICIO'].' '.$data[$i]['LUGAR_EJEC'].' ';
//  //   $pdf->MultiAlignCell(0,5,$contenidoFila,0,'LJ'); $pdf->Ln();

//     //$pdf->WriteHTML($contenidoFila);
    

//     //$pdf->MultiCell(0,5,$contenidoFila,0,'LJ');
   
//     //$pdf->MultiCell(0,5,$data[$i]['NOMBRE_PROYECTO'],0,'LJ');
//     //$pdf->Cell(0,10,$contenidoFila,1,1);
//    /* MultiAlignCell($w,$h,$text,$border=0,$ln=0,$align='L',$fill=false) */ 
    
//    $pdf->SetFont('Arial','B',10);

//     if(strcmp(trim($data[$i]['archivo']),'0') == 0){
//         $status = "En proceso: ";
//     }else{
//         $status = "Culminado: ";
//     } 

//     $pdf->Write(5,$status); 
//     $pdf->SetFont('Arial','',10);
    
//     $reemplazar=array('Á','É','Í','Ó','Ú');
//     $buscar=array('á','é','í','ó','ú');

//     //$nombreCliente=str_replace(utf8_decode($data[$i]['NOMBRE_CLIENTE']),$buscar,$reemplazar);

//     $nombreCliente=strtoupper($data[$i]['NOMBRE_CLIENTE']);
    


//     // $pdf->Write(5,utf8_decode($data[$i]['NOMBRE_SERVICIO'].' para el proyecto: '));
//     $pdf->Write(5,utf8_decode($data[$i]['NOMBRE_PROYECTO']).'. ');
//     $pdf->Write(5,utf8_decode($nombreCliente));
//     $pdf->Write(5,utf8_decode($data[$i]['LUGAR_EJEC']).' - ');
//     $pdf->Write(5,utf8_decode($data[$i]['FECHA']));
//     $pdf->Ln(10);

// }

for($i=0;$i<count($data);$i++){
    $pdf->SetFont('Arial','B',10);
    $pdf->MultiAlignCell(0,5,$data[$i]['NOMBRE_PROYECTO'],0,0,'J');
    $pdf->SetFont('Arial','',10);
    $pdf->MultiAlignCell(0,5,$data[$i]['LUGAR_EJEC'],0,0,'J');
    //$pdf->ln(5);

   }

$pdf->Output('listado_certificado.pdf','I');
?>