<?php
use setasign\Fpdi\Tcpdf\Fpdi;
require_once('../lib/tcpdf/tcpdf.php'); // Asegura que TCPDF estéen el servidor
require("../lib/fpdi2/src/autoload.php");
require("../clases/Bdd.php");
require("../clases/Certificado.php");

class PDF extends Fpdi {
    public $header = 1;
    public $footer = 1;

    // Cabecera modificada para TCPDF
    function Header() {
        if ($this->header == 1) {
            $this->Image('../img/logo.png', 162, 8, 46);
            $this->SetFont('helvetica', 'B', 15);
            $this->Cell(80);

            // Asignación de título en formato tradicional
            if ($_GET["ep"] == 0) {
                $titulo = 'Proyectos Realizados y en Ejecución';
            } else {
                $titulo = 'Proyectos Realizados';
            }

            $this->Cell(30, 10, $titulo, 0, 0, 'C');
            $this->SetFont('helvetica', '', 8);
            $this->Ln(11);
            $this->MultiCell(0, 0.2, '', 0, 'J', 1);
            $this->Ln(5);
        }
    }

    // Pie de página
    function Footer() {
        if ($this->footer == 1) {
            $this->SetY(267);
            $this->SetFont('helvetica', 'B', 8);
            $this->Cell(1, 6, 'CSF', 0, 0, 'L');
            $this->SetFont('helvetica', '', 8);
            $this->SetX(17);
            $this->Cell(1, 6, 'Propietario y Confidencial', 0, 0, 'L');
            $this->Cell(0, 6, date('M,Y'), 0, 0, 'R');
        }
    }
}

// Procesamiento inicial
$objCertif = new Certificado();
$bdd = new Bdd($objCertif->sql_proyectosRealizado($_GET), '../');
$data = $bdd->numeroRegistroSqlAfectado();
if ($data == -1) {
    die($bdd->sqlError());
} else {
    $data = filtrarFecha($bdd->dataSql(), $_GET['dd'], $_GET['ha']);
}

// Crear PDF
$pdf = new PDF('P', 'mm', 'Letter');
$pdf->SetCreator('Sistema CSF');
$pdf->SetMargins(15, 25, 15);
$pdf->SetAutoPageBreak(true, 25);
$pdf->header = 1;
$pdf->footer = 1;
$pdf->AddPage();

// Listado de proyectos
if (count($data) == 0) {
    echo "<script>alert('No hay datos'); window.close();</script>";
    exit;
}

$archivoVertificaciones = [];
$dataCount = count($data);
for ($i = 0; $i < $dataCount; $i++) {
    $item = $data[$i];
    $status = (trim($item['archivo']) == '0') ? "En Ejecución: " : "Culminado: ";

    if ($_GET["ep"] == 1 && $status == "En Ejecución: ") {
        continue;
    }

    // Procesar texto
    $nombreCliente = mb_convert_case($item['NOMBRE_CLIENTE'], MB_CASE_TITLE, "UTF-8");
    $fechaCertifi = '';
    if (!empty($item['FECHA'])) {
        $fechaCertifi = date_format(date_create($item['FECHA']), "Y");
    }

    // Contenido principal
    $pdf->SetFont('helvetica', 'B', 10);
    $pdf->Cell(0, 5, $status, 0, 1);
    $pdf->SetFont('helvetica', '', 10);

    // Asignación de texto en formato tradicional
    if ($_GET['check'] == 1) {
        $textoServicio = 'Servicios: ' . $item['NOMBRE_SERVICIO'];
    } else {
        $textoServicio = '';
    }

    $texto = sprintf('%s. %s %s - %s. %s',
        $item['NOMBRE_PROYECTO'],
        $nombreCliente,
        $item['LUGAR_EJEC'],
        $fechaCertifi,
        $textoServicio
    );

    $pdf->MultiCell(0, 5, $texto, 0, 'J');
    $pdf->Ln(8);

    if ($status == "Culminado: ") {
        $archivoVertificaciones[] = '../' . $item['archivo'];
    }
}

// Adjuntar archivos PDF (soporte)
if ($_GET["is"] == 1) {
    $archivoCount = count($archivoVertificaciones);
    for ($i = 0; $i < $archivoCount; $i++) {
        $file = $archivoVertificaciones[$i];
        /* por si falta algun archivo o no se subio lo informe */
        if (!file_exists($file)) {
            echo("<br>Archivo no encontrado: $file");
            continue;
        }

        try {
            $pageCount = $pdf->setSourceFile($file);
            $pdf->header = 0;

            for ($j = 0; $j < $pageCount; $j++) {
                $tpl = $pdf->importPage($j + 1);
                $pdf->AddPage();
                $pdf->useTemplate($tpl);
            }
        } catch (Exception $e) {
            error_log("Error en $file: " . $e->getMessage());
        }
    }
}

$pdf->Output('listado_certificado.pdf', 'I');

// Funciones auxiliares
function filtrarFecha($data, $dd, $ha) {
    if (empty($data)) {
        return [];
    }

    $filtered = [];
    $dataCount = count($data);
    for ($i = 0; $i < $dataCount; $i++) {
        $item = $data[$i];
        $fecha = $item['FECHA'] ?? null;
        if (!$fecha) {
            continue;
        }

        $cumple = true;
        if ($dd && $fecha < $dd) {
            $cumple = false;
        }
        if ($ha && $fecha > $ha) {
            $cumple = false;
        }

        if ($cumple) {
            $filtered[] = $item;
        }
    }
    return $filtered;
}
?>