<?php
use setasign\Fpdi\Fpdi;
use setasign\Fpdi\PdfReader;

require("../lib/fpdf/fpdf.php");
require("../lib/fpdi2/src/autoload.php");
require("../clases/Bdd.php");
require("../clases/Proyecto.php");

class PDF extends FPDI
{
    // Cabecera de página
    function Header()
    {
        if($this->header ==1){
            // Logo
            $this->Image('../img/logo.png',162,8,46);
            // Arial bold 15
            $this->SetFont('Arial','B',15);
            // Movernos a la derecha
            $this->Cell(80);
            // Título

            $titulo='Titulo ListadoProyecto';

            $this->Cell(30,10,utf8_decode($titulo),0,0,'C');
            $this->SetFont('Arial','',8);
            
            // Salto de línea
            $this->Ln(11);
            $this->MultiCell(0,0.2,'',0,0,'J',1);
            $this->Ln(5);
        }
    }

    // Pie de página
    function Footer()
    {
        // Posición: a 1,5 cm del final
        if($this->footer==1){
        $this->SetY(267);
        // // $this->Image('img/pie.png',0.3,240,215);

        //$this->SetY(-1.5);
        // Arial italic 8
        
        // Número de página
        $this->SetFont('Arial','',8);
        $this->MultiCell(0,0.2,'',0,0,'J',1);
        $this->SetFont('Arial','B',8);
        $this->Cell(1,6,'CSF',0,0,'L');
        $this->SetFont('Arial','',8);
        $this->SetX(17);
        $this->Cell(1,6,'Propietario y Confidencial',0,0,'L');
        $this->Cell(0,6,date('M,Y'),0,0,'R');
        $this->Ln(3);
        $this->Cell(199.5,8,'Page '.$this->PageNo().'/'.rtrim('{nb}'),0,1,'R');
        //incluir fecha de la generacion del reporte
    }}
}
//die(print_r($_GET));
// Creación del objeto de la clase heredada

$objCertif = new Proyecto();
$bdd = new Bdd($objCertif->sql_listadototalProyecto($_GET),'../');

$data=$bdd->numeroRegistroSqlAfectado();
if ($data == -1) {
    $data = "<br>".$bdd->sqlError();
}else{
    $data = $bdd->dataSql();
}

$pdf = new PDF('P','mm','Letter');
$pdf->header=1;
$pdf->footer=1;
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Arial','',10);

$archivoVertificaciones = array();

if (count($data) == 0) { 
    $mn = "No hay nada que reportar...";
            echo "<script language='JavaScript'>";
            echo "  alert('".$mn."');";
            echo "  window.close(); ";  
            echo "</script>";
    return;        
}

for($i=0;$i<count($data);$i++){ 
    
   $pdf->SetFont('Arial','B',10);

    // $pdf->Write(5,$status); 
    $pdf->SetFont('Arial','',10);

    $pdf->MultiCell(0,5,utf8_decode($data[$i]['COD_PROYECTO']).' '
                        .utf8_decode($data[$i]['NOMBRE_PROYECTO']).' '
                        .utf8_decode($data[$i]['FECHA_INI']).' '
                        .utf8_decode($data[$i]['FECHA_FIN']));
                        
    $pdf->Ln();
}

$pdf->Output('D','listado_certificado.pdf');

?>