/*==============================================================*/
/*                                                              */
/*==============================================================*/

drop table if exists accion_documento;
drop table if exists acciones;
drop table if exists documentos;
drop table if exists entregas;
drop table if exists unidad_negocio;
drop table if exists usuarios;

/*==============================================================*/
/* Table: acciones                                              */
/*==============================================================*/
create table acciones
(
   accion               varchar(40) not null,
   orden                float,
   primary key (accion)
);

/*==============================================================*/
/* Table: accion_documento                                      */
/*==============================================================*/
create table accion_documento
(
   nota_entrega         varchar(16) not null,
   accion               varchar(40) not null,
   primary key (nota_entrega, accion)
);

/*==============================================================*/
/* Table: documentos                                            */
/*==============================================================*/
create table documentos
(
   cod_document         int not null auto_increment,
   nota_entrega         varchar(16) not null,
   nro_documento        longtext,
   revision             varchar(2),
   nro_pag              int,
   nomb_documento       longtext,
   primary key (cod_document)
);

/*==============================================================*/
/* Table: entregas                                              */
/*==============================================================*/
create table entregas
(
   nota_entrega         varchar(16) not null,
   cod_unid_neg         varchar(20) not null,
   login                varchar(16) not null,
   cod_proyecto         varchar(20),
   nom_empresa          longtext,
   atencion             longtext,
   fecha                date,
   proyecto             longtext,
   fecha_envio          date,
   fecha_recibido       date,
   status_not_ent       varchar(15),
   dir_archivo_word     varchar(200),
   dir_archivo_emitido  varchar(200),
   dir_archivo_recibido varchar(200),
   emitido_por          longtext,
   recibido_por         longtext,
   razon_anulacion      longtext,
   observacion          longtext,
   primary key (nota_entrega)
);

/*==============================================================*/
/* Table: unidad_negocio                                        */
/*==============================================================*/
create table unidad_negocio
(
   cod_unid_neg         varchar(20) not null,
   descrip_unid_neg     longtext,
   siglas_unid_neg      varchar(20),
   primary key (cod_unid_neg)
);

/*==============================================================*/
/* Table: usuarios                                              */
/*==============================================================*/
create table usuarios
(
   login                varchar(16) not null,
   clave                varchar(16),
   nombres              longtext,
   apellidos            longtext,
   primary key (login)
);

alter table accion_documento add constraint fk_accion_documento foreign key (nota_entrega)
      references entregas (nota_entrega) on delete restrict on update restrict;

alter table accion_documento add constraint fk_accion_documento2 foreign key (accion)
      references acciones (accion) on delete restrict on update restrict;

alter table documentos add constraint fk_lista foreign key (nota_entrega)
      references entregas (nota_entrega) on delete restrict on update restrict;

alter table entregas add constraint fk_administra foreign key (login)
      references usuarios (login) on delete restrict on update restrict;

alter table entregas add constraint fk_afecta foreign key (cod_unid_neg)
      references unidad_negocio (cod_unid_neg) on delete restrict on update restrict;

/*==============================================================*/
/*  CONTENIDO   unidad_negocio                                  */
/*==============================================================*/

INSERT INTO unidad_negocio (cod_unid_neg, descrip_unid_neg, siglas_unid_neg) VALUES('PHA', 'Evaluación de Peligros y Riesgo', 'PHA');
INSERT INTO unidad_negocio (cod_unid_neg, descrip_unid_neg, siglas_unid_neg) VALUES('SCVS', 'Servicios del Ciclo de Vida de Seguridad Funcional', 'SCVS');
INSERT INTO unidad_negocio (cod_unid_neg, descrip_unid_neg, siglas_unid_neg) VALUES('SCVCS', 'Servicios del Ciclo de Vida de Cyber Security', 'SCVCS');
INSERT INTO unidad_negocio (cod_unid_neg, descrip_unid_neg, siglas_unid_neg) VALUES('SCVF&G', 'Servicios del Ciclo de Vida de Fuego y Gas', 'SCVF&G');
INSERT INTO unidad_negocio (cod_unid_neg, descrip_unid_neg, siglas_unid_neg) VALUES('Capacitación', 'Capacitación', 'Capacitación');
INSERT INTO unidad_negocio (cod_unid_neg, descrip_unid_neg, siglas_unid_neg) VALUES('EE', 'Estudios Especiales', 'EE');

/*==============================================================*/
/*  CONTENIDO   usuarios                                        */
/*==============================================================*/

INSERT INTO usuarios (login, clave, nombres, apellidos) VALUES('GRAUA', NULL, 'Ana', 'Grau');
INSERT INTO usuarios (login, clave, nombres, apellidos) VALUES('NUNESA', NULL, 'Andrei', 'Nuñez');
INSERT INTO usuarios (login, clave, nombres, apellidos) VALUES('DOMINGUEZC', NULL, 'Carlos', 'Dominguez');
INSERT INTO usuarios (login, clave, nombres, apellidos) VALUES('GUILARTEC', NULL, 'Carlos ', 'Guilarte');
INSERT INTO usuarios (login, clave, nombres, apellidos) VALUES('DURANL', NULL, 'Luis', 'Durán');
INSERT INTO usuarios (login, clave, nombres, apellidos) VALUES('HENRIQUEZM', NULL, 'Miguel', 'Henriques');
INSERT INTO usuarios (login, clave, nombres, apellidos) VALUES('HERNANDEZR', NULL, 'Ruddy', 'Hernandez');
INSERT INTO usuarios (login, clave, nombres, apellidos) VALUES('RODRIGUEZRX', NULL, 'Romel', 'Rodriguez');
INSERT INTO usuarios (login, clave, nombres, apellidos) VALUES('LORENZY', NULL, 'Yolanda', 'Lorenz');
INSERT INTO usuarios (login, clave, nombres, apellidos) VALUES('HERNANDEZC', NULL, 'Chanty ', 'Hernandez');
INSERT INTO usuarios (login, clave, nombres, apellidos) VALUES('GRAGELR', NULL, 'Rigleth', 'Gragel');
INSERT INTO usuarios (login, clave, nombres, apellidos) VALUES('VELANDIAK', NULL, 'Katherine', 'Velandia');
INSERT INTO usuarios (login, clave, nombres, apellidos) VALUES('RENGELK', NULL, 'Karen', 'Rengel');
INSERT INTO usuarios (login, clave, nombres, apellidos) VALUES('AVENDANOI', NULL, 'Isvelia', 'Avendaño');
INSERT INTO usuarios (login, clave, nombres, apellidos) VALUES('RAMIREZA', NULL, 'Ana María', 'Ramirez');

/*==============================================================*/
/*  CONTENIDO   acciones                                        */
/*==============================================================*/

INSERT INTO acciones (accion, orden) VALUES('Documento Final', 5);
INSERT INTO acciones (accion, orden) VALUES('Información / Archivo', 3);
INSERT INTO acciones (accion, orden) VALUES('Otros', 7);
INSERT INTO acciones (accion, orden) VALUES('Revisión y Comentarios', 1);