<?php 
require_once "Usuario.php";
require_once "Bdd.php";

class Seguridad{
    private $usuarioConectado='';
    private $rol;
    private $casoUso;
    //permiso is booleano
    public $permiso;

    private $conex_BDD;
    private $dir_base;
    public $sql;


    public function __construct($usuario,$dirBase=''){
        $this->usuarioConectado = $usuario;
        $this->dir_base = $dirBase;
        $this->rol = ''; /* consultar el rol del usuario */

    }
    /**
     * Evaluar si el usuario actualmente conectado tiene permiso al caso de uso (caso uso)
     * @param: int $casoUso: numero del caso de uso defninidos en la tabla caso_uso de la base de datos 
     * @author: Luis M Duran O
     * @return: true si tienen permiso
     *          false si no tiene permiso
     * @nota:  [tambien puede retornar una cadena con la razon del por que no tiene permiso, en dado caso siempre retornará true si tiene permiso]
     */
    public function permiso($casoUso){
        //echo "usuario = ".$this->usuarioConectado." caso = ". $casoUso."<br>"; 
        $this->casoUso = $casoUso;
        $user = new Usuario($this->usuarioConectado);
        $_BDD = new Bdd($user->sql_buscar($this->usuarioConectado),$this->dir_base);
        //$_BDD = new Bdd($user->sql_buscar('RANL'),$this->dir_base); // TEST

        //$data = $_BDD->dataSql();
        if($_BDD->numeroRegistroSqlAfectado() == 0){
            return "Usuario Invalido...";
        }else if ($_BDD->numeroRegistroSqlAfectado() == -1) {
		    //echo $user->sql_buscar();
		    $data = "<br>".$_BDD->sqlError();
            return $data; 
	    }else{
		    $data = $_BDD->dataSql();
	    }

        //print_r($data);die();

        // 1- esta activo el usuario ? 
        if(strcmp(trim($data[0][9]),'Activo')==0){
            $this->rol =$data[0][9];
            // consultar permisos por rol
            $resp = true;
        }else { //strcmp($data[9],'Inactivo')==0){
            $resp = "Usuario ".$this->usuarioConectado." esta Inactivo, consulte a su administrador de sistemas"; // Usuario no esta activo
        }

        //die($user->sql_buscar($this->usuarioConectado));

        /*
        1- esta activo el usuario ? 
        2- consultar su rol
            2.1 si tiene rol:
                2.1.1 consulta permiso por rol
                    si no tiene permiso por rol 
                    cosulta permiso individual
            2.2 si no tiene rol:
                2.2.1 cosulta permiso individual 
        2- tiene permiso en el rol de usuario
        3- tiene permiso individual
        */
        //print_r($resp); die();
        return $resp;
    }

    private function sql_lista_caso_usos(){
        $this->sql = sprintf("SELECT *, null as shequeado FROM seg_caso_uso;");
        return $this->sql;
    }

    private function sql_lista_caso_usos_por_rol($rol){
        $this->sql = sprintf("SELECT *, (select B.cod_caso_uso FROM seg_perfiles_roles as B where B.cod_rol = %d and B.cod_caso_uso = A.cod_caso_uso ) as shequeado FROM seg_caso_uso as A",$rol);
        return $this->sql;
    }
    
    private function sql_lista_caso_usos_por_usuario($usuario){
        $this->sql = sprintf("SELECT *, (select B.cod_caso_uso FROM seg_perfiles_usuario as B where B.login = '%s' and B.cod_caso_uso = A.cod_caso_uso ) as shequeado FROM seg_caso_uso as A",$usuario);
        return $this->sql;
    }
    /**
     * vista_lista_casos_usos(int cad): Construye una tabla con los permiso que tienen o no tienen los roles o usuarios en la aplicación
     * @param: int cad: valor: 0 (cero ) indica que cargar ra la vista base para asignar permisos
     *                         1 (uno) indica que se cargará los permisos en la vista de un rol 
     *                         2 (dos) indica que se cargará los permisos en la vista de un usuario 
     * @param: string actor: tendrá el login del usuario si el primer parametro es 1 (uno);
     *                       tendrá el codigo del rol si el primer parametro es 2 (dos);
     * @author: Luis M Duran O
     * @nota: si no se indican ningun parametro tomara en valor 0 (cero) por defeco
     */
    public function vista_lista_casos_usos($origenEnVista = 0, $actor=''){
        //

        // $_BDD = new Bdd($this->sql_lista_caso_usos_por_usuario('duranl'),'../');
        //die('$origenEnVista == '.$origenEnVista.' actor == '.$actor);
        if($origenEnVista == 0){
            $_BDD = new Bdd($this->sql_lista_caso_usos(),'../');
        }else if($origenEnVista == 1){
            $_BDD = new Bdd($this->sql_lista_caso_usos_por_rol($actor),'../');
        }else if($origenEnVista == 2){
            $_BDD = new Bdd($this->sql_lista_caso_usos_por_usuario($actor),'../');
        }


        if($_BDD->numeroRegistroSqlAfectado() == 0){
            return "Usuario Invalido...";
        }else if ($_BDD->numeroRegistroSqlAfectado() == -1) {
		    //echo $user->sql_buscar();
		    $data = "<br>".$_BDD->sqlError();
            return $data; 
	    }else{
		    $listaCasos = $_BDD->dataSql();
            //print_r($listaCasos);die();
            $datosTd = "";
            $anchoCampo1 = '100px';
            $anchoCampo2 = '830px';
            $anchoCampo3 = '150px';
            $datosTable = "<table id = 'tabla_Lista_Casos_Uso'>
                                <!--<thead style='position: fixed;z-index: 1;'>
                                    <tr>
                                        <th style = 'width:".$anchoCampo1."'>N°_CASO</th> 
                                        <th style = 'width:".$anchoCampo2."'>PROCESOS</th> 
                                        <th style = 'width:".$anchoCampo3."'>PERMISO</th> 
                                    </tr>
                                </thead>-->
                                <tr>
                                    <th style = 'height:22px; width:".$anchoCampo1."'>N°_CASO</th> 
                                    <th style = 'height:22px'>PROCESOS</th> 
                                    <th style = 'height:22px; width:".$anchoCampo3."'>PERMISO</th> 
                                </tr>";
            //print_r($listaCasos);die();
                    for ($i=0; $i < count($listaCasos); $i++) { 
                       // echo "<br>"."---".$listaCasos[$i]['shequeado']."---";
                        if (strcmp(trim($listaCasos[$i]['shequeado']),"") != 0) {
                            $checked = "checked";
                            $bandera = "1";
                        }else{
                            $checked = "";
                            $bandera = "0";
                        }
                        $datosTd = $datosTd.
                            "<tr title='".$listaCasos[$i]['descri_caso']."'>
                                <td style = 'text-align:center'>".$listaCasos[$i]['cod_caso_uso']."</td> 
                                <td>".$listaCasos[$i]['caso_uso']."</td> 
                                <td style = 'text-align:center'><input type='checkbox' id=".$listaCasos[$i]['cod_caso_uso']." value='".$listaCasos[$i]['cod_caso_uso']."_".$bandera."' style='cursor:pointer' onclick = 'seg.seg_checkbox(this.id)' ".$checked." ></td> 
                             </tr>";
                    }

            $data = $datosTable.$datosTd."</table>";
            //die($data);
            return $data;

	    }
    }
    /**
     * guardarPermisosPorRol: gurda los permisos que tendra un rol
     * @autor: Luis Durán O
     * @param: Array $data[1] = 'Rol' ó 'Usuario' // dependiendo de si se trata de un rol o un usuario
     *                    [2] = codigo del Rol // estaran definidos en la tabla "seg_roles"
     *                    [3] = codigo del Usuario // estaran definidos en la tabla "seg_usuario"
     *                    [5] = "1_0" ó "1_1": el primer numero corresponde al codigo del caso luego un caracter de separación "_" el segundo será 
     *                          cero (0) o uno (1); Cero indicarará que no tiene permiso al primer numero que sera el caso de uso y uno que si tiene.
     *                    [...n] = igual que [5] tendra permiso o no lo tendra a n casos de uso
     */
    public function guardarPermisos($data){
        //
        //die(print_r($data));
        $cod_rol = $data[2];
        $dataPermiso = array();

        for ($i=4; $i < count($data); $i++) { 
            $dataPermiso[]=$data[$i];
        }
        
        if(strcmp(trim($data[1]),"Rol") == 0){
            $sql = $this->guardarPermisosRoles($data[2],$dataPermiso);
        }else if(strcmp(trim($data[1]),"Usuario") == 0){
            $sql = $this->guardarPermisosUsuario($data[3],$dataPermiso);
        }

        //die($sql);

        $_BDD = new Bdd($sql,'../');

        return true;
    }
    
    private function guardarPermisosRoles($codigoRol,$dataPermisos){
        $sql1 = $this->borrarPermisoRol($codigoRol);
        $sql2 = "";

        for ($i=0; $i < count($dataPermisos); $i++) { 
            $casoUso = explode("_",$dataPermisos[$i]);
            if($casoUso[1] == 1){
                $sql2 = $sql2.sprintf("INSERT INTO seg_perfiles_roles (cod_rol, cod_caso_uso) VALUES (%d, %d);",$codigoRol, $casoUso[0]);
            }
        }
        return $sql1.$sql2;

    }

    private function borrarPermisoRol($codigoRol){
        $sql = sprintf("DELETE FROM seg_perfiles_roles WHERE cod_rol = %d ;",$codigoRol);
        return $sql;
    }

    private function guardarPermisosUsuario($codidoUsuario,$dataPermisos){
        $sql1 = $this->borrarPermisoUsuario($codidoUsuario);
        $sql2 = "";

        for ($i=0; $i < count($dataPermisos); $i++) { 
            $casoUso = explode("_",$dataPermisos[$i]);
            if($casoUso[1] == 1){
                $sql2 = $sql2.sprintf("INSERT INTO seg_perfiles_usuario (login, cod_caso_uso) VALUES ('%s', %d);",$codidoUsuario, $casoUso[0]);
            }
        }
        return $sql1.$sql2;
    }

    private function borrarPermisoUsuario($codidoUsuario){
        $sql = sprintf("DELETE FROM seg_perfiles_usuario WHERE login = '%s';",$codidoUsuario);
        return $sql;
    }

    public function permisosUsuario(){
        $_BDD = new Bdd('',$this->dir_base);

        $sql = "SELECT A.cod_caso_uso FROM seg_perfiles_usuario as A
                WHERE login = ?
                UNION 
                SELECT A.cod_caso_uso 
                FROM seg_perfiles_roles as A, seg_usuarios_roles as C
                WHERE C.login = ?
                    AND C.cod_rol = A.cod_rol";
        $types = "ss";
        $params = [$this->usuarioConectado,$this->usuarioConectado];

        $dta= $_BDD->ejecutarConsultaPreparada($sql, $types, $params);

        $permisos = array();
        for ($i=0; $i < count($dta); $i++) { 
            $permisos[$i] = $dta[$i]['cod_caso_uso'];
        }

        return $permisos;
    }

}


?>