<?php
require('lib/fpdf/fpdf.php');
include_once('conf/amdconfig.php');

ini_set("display_errors", "0");


class PDF extends FPDF
{
	// Cabecera de página
	function Header()
	{
	    // Logo
	    $logo = "img/csf_logo.jpeg";
	    $this->Image($logo,150,10,39);
	    if (LOGOAGUAENPDF == 1) {
	    	$logoSim = "img/csf_logoSim20.jpeg";
	    	$this->Image($logoSim,10,50,190);
	    }
	    
	    // Arial bold 15
	    $this->SetFont('Arial','B',15);
	}

	// Pie de página
	function Footer()
	{
		$this->SetXY(5,-20);

		$this->Cell(200,2,'','T',1);
		$this->SetFont('Arial','',7.6);
		$this->Cell(190,3.5,utf8_decode('CSF. Consultoria en Seguridad Funcional y Seguridad de Procesos. | www.grupocsf.com | Mail: nuneza@grupocsf.com, rodriguezrx@grupocsf.com,'),'',1,'C');
		$this->Cell(190,3.5,utf8_decode('montanog@grupocsf.com, hernadezc@grupocsf.com | Anzoategui-Venezuela: +58(424) 827 1202, Bogotá-Colombia +57 (467) 9691,'),'',1,'C');
		$this->Cell(190,3.5,utf8_decode('Santa Cruz Bolivia +591 (7) 0744633, USA: Doral-Florida +1 (305) 250 1814'),'',1,'C');
	    // Posición: a 1,2 cm del final y 19,4cm a la derecha
		$this->SetXY(194,-12);
	    // Arial italic 8
	    $this->SetFont('Arial','I',8);
	    // Número de página
	    $this->Cell(0,0.8,'Pag. '.$this->PageNo().'/{nb}',0,0,'C');
	}
}

/* obteniendo datos*/
include_once("clases/Sql.php");
include_once("clases/Bdd.php");
$caso = '4'; // consultar nota de entrega por codigo
$data[0] = $caso;
$data[1] = trim($_GET['n']);

$sql = new Sql($data); 
$bdd = new Bdd($sql->cadenaSQL());
$datos[0] = $bdd->dataSql();


$caso = '5'; // consultar acciones nota de entrega por codigo
$data[0] = $caso;
$data[1] = trim($_GET['n']);

$sql = new Sql($data); 
$bdd = new Bdd($sql->cadenaSQL());
$datos[1] = $bdd->dataSql();

$caso = '6'; // consultar listado de documentos de la nota entrega por codigo
$data[0] = $caso;
$data[1] = trim($_GET['n']);

$sql = new Sql($data); 
$bdd = new Bdd($sql->cadenaSQL());
$datos[2] = $bdd->dataSql();


// Creación del objeto de la clase heredada
$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();


$pos = 30;
$tamanioFuente = 8;
$fuente='Arial';

$pdf->SetY($pos);

$pdf->SetFont($fuente,'B',$tamanioFuente);
$pdf->Cell(36,8,utf8_decode('EMPRESA / COMPAÑIA:'),'LT');

$pdf->SetFont($fuente,'',$tamanioFuente);
$pdf->Cell(90,8,utf8_decode($datos[0][0]['nom_empresa']),'T');

$pdf->SetFont($fuente,'B',$tamanioFuente);
$pdf->Cell(34,8,utf8_decode('NOTA DE ENTREGA N°:'),'LT');

$pdf->SetFont($fuente,'',$tamanioFuente);
$pdf->Cell(30,8,utf8_decode($datos[0][0]['nota_entrega']),'TR',1);


$pdf->SetFont($fuente,'B',$tamanioFuente);
$pdf->Cell(36,8,utf8_decode('ATENCIÓN:'),'LB');

$pdf->SetFont($fuente,'',$tamanioFuente);
$pdf->Cell(90,8,utf8_decode($datos[0][0]['atencion']),'B');

$pdf->SetFont($fuente,'B',$tamanioFuente);
$pdf->Cell(34,8,utf8_decode('FECHA:'),'LB');

$pdf->SetFont($fuente,'',$tamanioFuente);
$pdf->Cell(30,8,utf8_decode($datos[0][0]['fecha']),'RB',1);

$pdf->SetFont($fuente,'B',$tamanioFuente);
$pdf->Cell(20,8,utf8_decode('PROYECTO:'),'LB');

$pdf->Cell(170,8,utf8_decode($datos[0][0]['proyecto']),'LRB',1);

$pdf->SetFont($fuente,'',$tamanioFuente);
$pdf->Cell(190,8,utf8_decode('Los Documentos entregados de deben utilizar segun las siguientes acciones:'),'LRB',1);
$iAux = 0;
$coorY = $pdf->GetY();
$coorX = $pdf->GetX();
$columnas= 3;
$cantFila = count($datos[1]) / $columnas;
$anchoColumna = 190/$columnas;


//$posAux=0;

for ($i=0; $i < count($datos[1]); $i++) {
//print_r($datos[1]); 

	if (strcmp(trim($datos[1][$i]['sheck']),trim($datos[1][$i]['accion'])) == 0) {
		$contenido = "_X_".$datos[1][$i]['accion'];
	}else{
		$contenido = "___".$datos[1][$i]['accion'];	
	}
	
	if($iAux==0){
		if(count($datos[1])-1 == $i){
			$anchoColumna = 190;
			$pdf->Cell($anchoColumna,8,utf8_decode($contenido),'LR',1);
		}else{
			$pdf->Cell($anchoColumna,8,utf8_decode($contenido),'L');
		}
		
	}else if($iAux == 2){
		$pdf->Cell($anchoColumna,8,utf8_decode($contenido),'R',1);
		$iAux = -1;
	}else {
		if(count($datos[1])-1 == $i){
			$anchoColumna = $anchoColumna*2;
			$pdf->Cell($anchoColumna,8,utf8_decode($contenido),'LR',1);
		}else{
			$pdf->Cell($anchoColumna,8,utf8_decode($contenido),'');
		}
	}
	$iAux++;

	/* impresin vertical falla
		//echo '('.$cantFila .' < '. $iAux.')';
		if($cantFila < $iAux){
			
			$iAux = 0;
			$coorX = $coorX + $anchoColumna;
			$pdf->SetX($coorX);
			//$coorY = $coorY ;
			//$pdf->SetY($coorY);

			$pdf->Cell($anchoColumna,8,$iAux.'-**'.$i.utf8_decode($contenido).'b','L',1);
			//$coorY = $coorY + $anchoColumna;
			
			//$pdf->SetXY($coorX,$coorY);
			//echo '<br>entra ('.$cantFila .' < '. $iAux.')';
			//break;
		}else{
			$pdf->SetX($coorX);
			//$pdf->SetY($anchoColumna);
			$pdf->Cell($anchoColumna,8,$iAux.'-'.$i.utf8_decode($contenido).'b','L',1);
		}
		$iAux++;
	*/
}
$pdf->Cell(190,8,'','T',1);
$pdf->Ln();
//$pdf->Cell(190,8,'','LBR',1);	

$pdf->SetFont($fuente,'B',$tamanioFuente);
$pdf->Cell(70,8,utf8_decode('DOCUMENTO N°'),'TBL');
$pdf->Cell(15,8,utf8_decode('REV.'),'TBL');
$pdf->Cell(15,8,utf8_decode('Nro. PÁG.'),'TBL');
$pdf->Cell(90,8,utf8_decode('NOMBRE DEL DOCUMENTO'),'TBLR',1);
$pdf->Cell(190,2,'','',1);


$pdf->SetFont($fuente,'',$tamanioFuente);
//print_r($datos[2]);
$tamanioCadenaGrande = 0;
for ($i=0; $i < count($datos[2]); $i++) { 
	$tamCadMax = strlen($datos[2][$i]['nomb_documento']);
	if ($tamCadMax > $tamanioCadenaGrande) {
		$tamanioCadenaGrande = $tamCadMax;
	}
}

for ($i=0; $i < count($datos[2]); $i++) { 
	if ($i>0) {
		
		$linea = 'T';
	}else{
		$linea = '';
	}
	$pdf->Ln();
	$pdf->Cell(70,12,utf8_decode($datos[2][$i]['nro_documento']),$linea);
	$pdf->Cell(15,12,utf8_decode($datos[2][$i]['revicion']),$linea);
	$pdf->Cell(15,12,utf8_decode($datos[2][$i]['nro_pag']),$linea);
	$pdf->MultiCell(90,4,str_pad(utf8_decode($datos[2][$i]['nomb_documento']),$tamanioCadenaGrande,'    ',STR_PAD_RIGHT),$linea);
	//$pdf->Write(5,utf8_decode($datos[2][$i]['nomb_documento']));
}
$pdf->Cell(190,8,'','B',1);

$pdf->SetXY(10,230);
$pdf->SetFont($fuente,'B',$tamanioFuente);
$pdf->Cell(130,8,utf8_decode('Observaciones:'),'TBL');
$pdf->Cell(30,8,utf8_decode('Revisado por:'),'TBL');
$pdf->Cell(30,8,utf8_decode('Recivido por:'),'TBLR',1);

$pdf->SetFont($fuente,'',$tamanioFuente);
$pdf->MultiCell(130,6,utf8_decode('Favor devolver firmado y sellado. En caso contrario, enviar correo confirmando la recepción de los documentos.'),'L');
$pdf->SetXY(140,238);
$pdf->Cell(30,20,utf8_decode(''),'L');
$pdf->Cell(30,20,utf8_decode(''),'LR',1);
$pdf->Cell(190,2,'','T',1);
$pdf->Output();
?>
